using System;
using System.Collections.Generic;
using System.Linq;

public class MagicSailboat
{
    private class Mast
    {
        public long X { get; set; }
        public long H { get; set; }
        public int OriginalIndex { get; set; }
        public long MinDist { get; set; }

        public Mast(long x, long h, int originalIndex)
        {
            X = x;
            H = h;
            OriginalIndex = originalIndex;
            MinDist = -1;
        }
    }

    public void Solve()
    {
        int n = ReadInt();
        long[] x = ReadLongArray();
        long[] h = ReadLongArray();

        Mast[] masts = new Mast[n];
        for (int i = 0; i < n; i++)
        {
            masts[i] = new Mast(x[i], h[i], i);
        }

        Array.Sort(masts, (a, b) => a.X.CompareTo(b.X));

        long[] finalResults = new long[n];
        for (int i = 0; i < n; i++) finalResults[i] = -1;

        FindClosestRight(masts, n);
        FindClosestLeft(masts, n);

        for (int i = 0; i < n; i++)
        {
            finalResults[masts[i].OriginalIndex] = masts[i].MinDist;
        }

        foreach (long result in finalResults)
        {
            Console.WriteLine(result);
        }
    }

    private void FindClosestRight(Mast[] masts, int n)
    {
        Stack<Mast> stackRight = new Stack<Mast>();

        for (int i = 0; i < n; i++)
        {
            Mast current = masts[i];

            while (stackRight.Count > 0)
            {
                Mast top = stackRight.Peek();
                if (top.H + top.X <= current.H + current.X)
                {
                    stackRight.Pop();
                }
                else
                {
                    break;
                }
            }

            if (stackRight.Count > 0)
            {
                Mast candidate = stackRight.Peek();
                
                long xp_numerator = current.X + candidate.X + candidate.H - current.H;
                long xp = xp_numerator / 2;
                
                long dist = 2 * (xp - current.X);
                
                if (current.MinDist == -1 || dist < current.MinDist)
                {
                    current.MinDist = dist;
                }
            }
            
            stackRight.Push(current);
        }
    }

    private void FindClosestLeft(Mast[] masts, int n)
    {
        Stack<Mast> stackLeft = new Stack<Mast>();

        for (int i = n - 1; i >= 0; i--)
        {
            Mast current = masts[i];

            while (stackLeft.Count > 0)
            {
                Mast top = stackLeft.Peek();
                if (top.H - top.X <= current.H - current.X)
                {
                    stackLeft.Pop();
                }
                else
                {
                    break;
                }
            }

            if (stackLeft.Count > 0)
            {
                Mast candidate = stackLeft.Peek();
                
                long xp_numerator = current.X + candidate.X - candidate.H + current.H;
                long xp = xp_numerator / 2;
                
                long dist = 2 * (current.X - xp);
                
                if (current.MinDist == -1 || dist < current.MinDist)
                {
                    current.MinDist = dist;
                }
            }
            
            stackLeft.Push(current);
        }
    }

    private int ReadInt()
    {
        return int.Parse(Console.ReadLine());
    }

    private long[] ReadLongArray()
    {
        return Console.ReadLine().Split(' ').Select(long.Parse).ToArray();
    }
}